/*
 * Decompiled with CFR 0.152.
 */
package de.z0rdak.yawp.api.core.region;

import de.z0rdak.yawp.api.permission.Permissions;
import de.z0rdak.yawp.core.area.AreaType;
import de.z0rdak.yawp.core.flag.IFlag;
import de.z0rdak.yawp.core.flag.RegionFlags;
import de.z0rdak.yawp.core.group.PlayerContainer;
import de.z0rdak.yawp.core.region.IMarkableRegion;
import de.z0rdak.yawp.platform.Services;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import net.minecraft.class_1657;
import net.minecraft.class_1937;
import net.minecraft.class_270;
import net.minecraft.class_5321;

public abstract class LocalRegionBuilder<T extends IMarkableRegion> {
    protected final Map<String, PlayerContainer> groups;
    protected String name;
    protected int priority = 0;
    protected class_5321<class_1937> dim;
    protected boolean active = true;
    protected boolean muted = false;
    protected RegionFlags flags = new RegionFlags();
    protected AreaType areaType;

    protected LocalRegionBuilder(String name) {
        this();
        this.name = name;
    }

    protected LocalRegionBuilder() {
        this.groups = new HashMap<String, PlayerContainer>();
        Permissions.GROUP_LIST.forEach(group -> this.groups.put((String)group, new PlayerContainer((String)group)));
    }

    public LocalRegionBuilder<T> withName(String name) {
        this.name = name;
        return this;
    }

    public LocalRegionBuilder<T> withPriority(int priority) {
        this.priority = priority;
        return this;
    }

    public LocalRegionBuilder<T> withDefaultPriority() {
        return this.withPriority(Services.REGION_CONFIG.getDefaultPriority());
    }

    public LocalRegionBuilder<T> inDim(class_5321<class_1937> dim) {
        this.dim = dim;
        return this;
    }

    public LocalRegionBuilder<T> inDim(class_1937 level) {
        this.dim = level.method_27983();
        return this;
    }

    public LocalRegionBuilder<T> active(boolean active) {
        this.active = active;
        return this;
    }

    public LocalRegionBuilder<T> off() {
        return this.active(false);
    }

    public LocalRegionBuilder<T> on() {
        return this.active(true);
    }

    public LocalRegionBuilder<T> mute(boolean muted) {
        this.muted = muted;
        return this;
    }

    public LocalRegionBuilder<T> mute() {
        return this.mute(true);
    }

    public LocalRegionBuilder<T> addGroup(String groupName) {
        this.groups.put(groupName, new PlayerContainer(groupName));
        return this;
    }

    public LocalRegionBuilder<T> addGroup(PlayerContainer group) {
        this.groups.put(group.getGroupName(), group);
        return this;
    }

    public LocalRegionBuilder<T> addTeam(String groupName, class_270 team) {
        if (!this.groups.containsKey(groupName)) {
            this.groups.put(groupName, new PlayerContainer(groupName));
        }
        this.groups.get(groupName).addTeam(team.method_1197());
        return this;
    }

    public LocalRegionBuilder<T> addPlayer(String groupName, class_1657 player) {
        if (!this.groups.containsKey(groupName)) {
            this.groups.put(groupName, new PlayerContainer(groupName));
        }
        this.groups.get(groupName).addPlayer(player.method_5667(), player.method_5820());
        return this;
    }

    public LocalRegionBuilder<T> withFlags(RegionFlags flags) {
        this.flags = flags;
        return this;
    }

    public LocalRegionBuilder<T> withFlags(List<IFlag> flags) {
        if (this.flags == null) {
            this.flags = new RegionFlags();
        }
        flags.forEach(flag -> this.flags.put((IFlag)flag));
        return this;
    }

    public LocalRegionBuilder<T> addFlag(IFlag flag) {
        if (this.flags == null) {
            this.flags = new RegionFlags();
        }
        this.flags.put(flag);
        return this;
    }

    public abstract T build();
}

